/*  Wizard */
/*
jQuery(function($) {
    "use strict";
    // Chose below which method to send the email, available:
    // Simple phpmail text/plain > send_email_1.php (default)
    // PHPMailer text/html > phpmailer/send_email_1_phpmailer.php
    // PHPMailer text/html SMTP > phpmailer/send_email_1_phpmailer_smtp.php
    // PHPMailer with html template > phpmailer/send_email_1_phpmailer_template.php
    // PHPMailer with html template SMTP > phpmailer/send_email_1_phpmailer_template_smtp.php
    $('form#wrapped').attr('action', 'send_email_1.php');
    $("#wizard_container").wizard({
        stepsWrapper: "#wrapped",
        submit: ".submit",
        unidirectional: false,
        beforeSelect: function(event, state) {
            if ($('input#website').val().length != 0) {
                return false;
            }
            if (!state.isMovingForward)
                return true;
            var inputs = $(this).wizard('state').step.find(':input');
            return !inputs.length || !!inputs.valid();
        }
    }).validate({
        errorPlacement: function(error, element) {
            if (element.is(':radio') || element.is(':checkbox')){
                error.insertBefore(element.next());
            } else {
                error.insertAfter(element);
            }
        }
    });
    //  progress bar
    $("#progressbar").progressbar();
    $("#wizard_container").wizard({
        afterSelect: function(event, state) {
            $("#progressbar").progressbar("value", state.percentComplete);
            $("#location").text("" + state.stepsComplete + " of " + state.stepsPossible + " completed");
        }
    });
    $(".for-ug").hide();
    $(".for-pg").hide();
});

$("#wizard_container").wizard({
    transitions: {
        branchtype: function($step, action) {
            var branch = $step.find(":checked").val();
            if (!branch) {
                $("form").valid();
            }
            return branch;
        }
    }
});
*/

/* File upload validate size and file type - For details: https://github.com/snyderp/jquery.validate.file*/
$("form#wrapped")
    .validate({
        rules: {
            fileupload: {
                fileType: {
                    types: ["pdf", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document"]
                },
                maxFileSize: {
                    "unit": "KB",
                    "size": 150
                },
                minFileSize: {
                    "unit": "KB",
                    "size": "2"
                }
            },
            phone:{
                required: true,
                number: true,
                minlength: 10,
                maxlength: 12
            },
			medium:{
                required: true
            },
			board:{
                required: true
            },
			parentcontact:{
                required: true,
                number: true,
                minlength: 10,
                maxlength: 12
            },
			aadharnumber:{
                required: true,
                number: true,
                minlength: 12,
                maxlength: 12
            }
        },
        messages:{
            phone:{
                minlength: "Please enter valid Phone Number",
                maxlength: "Please enter valid Phone Number",
            },
			parentcontact:{
                minlength: "Please enter valid Phone Number",
                maxlength: "Please enter valid Phone Number",
            },
			aadharnumber:{
                minlength: "Please enter valid Aadhar Number",
                maxlength: "Please enter valid Aadhar Number",
            }
        }
    });

// Input name and email value
function getVals(formControl, controlType) {
    switch (controlType) {

        case 'name_field':
            // Get the value for input
            var value = $(formControl).val();
            $(".name_field").text(value);
            break;

        case 'email_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#email_field").text(value);
            break;

        case 'phone_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#phone_field").text(value);
            break;

        case 'gender_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#gender_field").text(value);
            break;

        case 'nationality_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#nationality_field").text(value);
            break;

        case 'age_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#age_field").text(value);
            break;

        case 'dob_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#dob_field").text(value);
            break;

        case 'stream_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#stream_field").text(value);
            break;

        case 'course_type_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#course_type_field").text(value);
            break;
			
		case 'medium_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#medium_field").text(value);
            break;
			
		case 'board_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#board_field").text(value);
            break;
		
		case 'school_name_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#school_name_field").text(value);
            break;

        /* case 'course_1_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#course_1_field").text(value);
            break;

        case 'course_2_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#course_2_field").text(value);
            break;

        case 'ten_mark_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#ten_mark_field").text(value);
            break;

        case 'plustwo_mark_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#plustwo_mark_field").text(value);
            break;

        case 'phy_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#phy_field").text(value);
            break;

        case 'chem_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#chem_field").text(value);
            break;

        case 'maths_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#maths_field").text(value);
            break;

        case 'major_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#major_field").text(value);
            break;

        case 'major_mark_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#major_mark_field").text(value);
            break;

        case 'ug_mark_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#ug_mark_field").text(value);
            break;
            
        case 'ug_stream_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#ug_stream_field").text(value);
            break; */
        case 'parent_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#parent_field").text(value);
            break;
		case 'mother_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#mother_field").text(value);
            break;
		case 'parents_number':
            // Get the value for input
            var value = $(formControl).val();
            $("#parents_number").text(value);
            break;
		case 'parents_email':
            // Get the value for input
            var value = $(formControl).val();
            $("#parents_email").text(value);
            break;
		case 'religion_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#religion_field").text(value);
            break;
        case 'community_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#community_field").text(value);
            break;
        case 'address_1_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#address_1_field").text(value);
            break;
        case 'address_2_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#address_2_field").text(value);
            break;
        case 'city_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#city_field").text(value);
            break;
        case 'pin_code_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#pin_code_field").text(value);
            break;
        case 'state_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#state_field").text(value);
            break;
		case 'aadhar_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#aadhar_field").text(value);
            break;
		case 'medium_field':
            // Get the value for input
            var value = $(formControl).val();
            $("#medium_field").text(value);
            break;
    }
}
var streamJsonList = {
    "streamTable":[
        {"streatID": "", "stream": "Select Stream"},
        {"streatID": "Under Graduate", "stream": "Under Graduate"}
    ]
}; 
var coursetypeJsonList = {
    "Under Graduate":[
		{"courseID": "", "course": "Select Branch"},
		{"courseID": "B.Tech Biotechnology", "course": "B.Tech Biotechnology"},
		{"courseID": "BE Artificial Intelligence and Data Sciences", "course": "BE Artificial Intelligence and Data Sciences"},
		{"courseID": "BE Electronics and Communications Engineering", "course": "BE Electronics and Communications Engineering"},
		{"courseID": "BE Bio Medical Engineering", "course": "BE Bio Medical Engineering"},
		{"courseID": "BE Civil Engineering", "course": "BE Civil Engineering"},
		{"courseID": "BE Computer Science and Engineering", "course": "BE Computer Science and Engineering"},
		{"courseID": "BE Computer Science and Engineering - Cyber Security", "course": "BE Computer Science and Engineering - Cyber Security"},
		{"courseID": "BE Electrical and Electronics Engineering", "course": "BE Electrical and Electronics Engineering"},
		{"courseID": "BE Mechatronics Engineering", "course": "BE Mechatronics Engineering"},
		{"courseID": "BE Mechanical Engineering", "course": "BE Mechanical Engineering"},
		{"courseID": "BE Pharmaceutical Engineering", "course": "BE Pharmaceutical Engineering"},
    ]
};
var courseJsonList = {
    // "Arts and Science":[{
    //     "Under Graduate":[
    //         {"courseID": "", "course": "Select Course"},
    //         {"courseID": "BBA", "course": "BBA"},
    //         {"courseID": "Commerce", "course": "Commerce"},
    //         {"courseID": "Computer Science", "course": "Computer Science"},
    //         {"courseID": "Tamil", "course": "Tamil"},
    //         {"courseID": "English", "course": "English"},
    //         {"courseID": "Maths", "course": "Maths"},
    //         {"courseID": "Chemistry", "course": "Chemistry"},
    //         {"courseID": "Physics", "course": "Physics"},
    //     ],
    //     "Post Graduate":[
    //         {"courseID": "", "course": "Select Course"},
    //     ]
    // }],
    "Engineering":[{
        "Under Graduate":[
            {"courseID": "", "course": "Select Course"},
            {"courseID": "B.Tech Biotechnology", "course": "B.Tech Biotechnology"},
            {"courseID": "BE Artificial Intelligence and Data Sciences", "course": "BE Artificial Intelligence and Data Sciences"},
            {"courseID": "BE Electronics and Communications Engineering", "course": "BE Electronics and Communications Engineering"},
            {"courseID": "BE Bio Medical Engineering", "course": "BE Bio Medical Engineering"},
            {"courseID": "BE Civil Engineering", "course": "BE Civil Engineering"},
            {"courseID": "BE Computer Science and Engineering", "course": "BE Computer Science and Engineering"},
            {"courseID": "BE Computer Science and Engineering - Cyber Security", "course": "BE Computer Science and Engineering - Cyber Security"},
            {"courseID": "BE Electrical and Electronics Engineering", "course": "BE Electrical and Electronics Engineering"},
            {"courseID": "BE Mechatronics Engineering", "course": "BE Mechatronics Engineering"},
            {"courseID": "BE Mechanical Engineering", "course": "BE Mechanical Engineering"},
            {"courseID": "BE Pharmaceutical Engineering", "course": "BE Pharmaceutical Engineering"},
        ],
        "Post Graduate":[
            {"courseID": "", "course": "Select Course"},
            {"courseID": "M.Tech Biotechnology", "course": "M.Tech Biotechnology"},
            {"courseID": "ME Embedded Systems Technologies", "course": "ME Embedded Systems Technologies"},
            {"courseID": "ME Construction Engineering and Management", "course": "ME Construction Engineering and Management"},
            {"courseID": "ME Computer Science and Engineering", "course": "ME Computer Science and Engineering"},
            {"courseID": "ME Power System Engineering", "course": "ME Power System Engineering"},
            {"courseID": "ME Manufacturing Engineering", "course": "ME Manufacturing Engineering"},
        ]
    }],
    "Management":[{
        "Under Graduate":[
            {"courseID": "", "course": "Select Course"},
        ],
        "Post Graduate":[
            {"courseID": "", "course": "Select Course"},
            {"courseID": "MBA", "course": "MBA"},
        ]
    }],
};
//Now that the doc is fully ready - populate the lists      
//Next comes the make   
var ModelListItems = "";    
for (var i = 0; i < streamJsonList.streamTable.length; i++) {   
    ModelListItems += "<option value='" + streamJsonList.streamTable[i].streatID + "'>" + streamJsonList.streamTable[i].stream + "</option>";   
}   
$("#stream").html(ModelListItems);  
var UpdateCourseType = function (stream) {    
    var listItems = ""; 
    for (var i = 0; i < coursetypeJsonList[stream].length; i++) {   
        listItems += "<option value='" + coursetypeJsonList[stream][i].courseID + "'>" + coursetypeJsonList[stream][i].course + "</option>";    
    }   
    $("select#course_type").html(listItems);
}
var UpdateCourseList = function (stream,course_type) {    
    var listItems = ""; 
    for (var i = 0; i < courseJsonList[course_type][0][stream].length; i++) {   
        listItems += "<option value='" + courseJsonList[course_type][0][stream][i].courseID + "'>" + courseJsonList[course_type][0][stream][i].course + "</option>";    
    }
    $("select#course_1").html(listItems);
    $("select#course_2").html(listItems);
}
$("select#stream").on('change', function () {
    var selectedStream = $('#stream option:selected').text();
    UpdateCourseType(selectedStream);
    if(selectedStream =="Under Graduate"){
        $(".for-ug").show();
        $(".for-ug .form-control").addClass("required");
        $(".for-ug .fileupload input").addClass("required");
        $(".for-pg").hide();
        $(".for-pg .form-control").removeClass("required");
        $(".for-pg .fileupload input").removeClass("required");
        $("#maths").removeClass("required");
        $("#plustwo_marksheet").removeClass("required");
    }else if(selectedStream =="Post Graduate"){
        $(".for-pg").show();
        $(".for-pg .form-control").addClass("required");
        $(".for-pg .fileupload input").addClass("required");
        $(".for-ug").hide();
        $(".for-ug .form-control").removeClass("required");
        $(".for-ug .fileupload input").removeClass("required");
    }
});
$("select#course_type").on('change', function () {
    var selectedStream = $('#stream option:selected').text();
    var courseType =$('#course_type option:selected').text(); 
    UpdateCourseList(selectedStream, courseType); 
});